# SWR License Server

Smart Word Replacer eklentisi için lisans yönetim sunucusu.

## 📋 Gereksinimler

- PHP 7.4+
- MySQL 5.7+
- SSL Sertifikası (HTTPS zorunlu)

## 🚀 Kurulum

### 1. Dosyaları Yükleyin
Tüm dosyaları `license.zefre.net` domain'ine yükleyin.

### 2. Veritabanı Oluşturun
```sql
CREATE DATABASE license_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'license_user'@'localhost' IDENTIFIED BY 'güçlü_şifre';
GRANT ALL PRIVILEGES ON license_db.* TO 'license_user'@'localhost';
FLUSH PRIVILEGES;
```

### 3. Schema'yı Import Edin
```bash
mysql -u license_user -p license_db < install/schema.sql
```

### 4. Config Dosyasını Düzenleyin
`includes/config.php` dosyasını açın ve şunları değiştirin:

```php
// Veritabanı bilgileri
define('DB_HOST', 'localhost');
define('DB_NAME', 'license_db');
define('DB_USER', 'license_user');
define('DB_PASS', 'güçlü_şifre');

// Paynet API bilgileri
define('PAYNET_TEST_MODE', false); // Canlıda false yapın
define('PAYNET_SECRET_KEY', 'paynet_secret_key');
define('PAYNET_PUBLIC_KEY', 'paynet_public_key');

// Admin bilgileri (admin/index.php'de de değiştirin)
$admin_user = 'admin';
$admin_pass = 'güçlü_admin_şifresi';
```

### 5. .htaccess Oluşturun
```apache
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]

# API için
RewriteRule ^api/v1/(.*)$ api/v1/$1.php [L,QSA]
```

## 📁 Dosya Yapısı

```
license-server/
├── api/v1/
│   ├── activate.php      # POST /api/v1/activate
│   ├── deactivate.php    # POST /api/v1/deactivate
│   ├── verify.php        # POST /api/v1/verify
│   └── status.php        # POST /api/v1/status
├── admin/
│   ├── index.php         # Admin paneli
│   └── ajax.php          # AJAX handler
├── includes/
│   ├── config.php        # Ayarlar
│   ├── class-database.php
│   ├── class-license.php
│   ├── class-api-handler.php
│   └── class-paynet.php
├── install/
│   └── schema.sql        # Veritabanı şeması
├── checkout.php          # Ödeme sayfası
├── callback.php          # Paynet callback
└── success.php           # Başarılı ödeme sayfası
```

## 💰 Fiyatlandırma

| Tip | Site | Süre | Fiyat |
|-----|------|------|-------|
| Starter | 1 | Yıllık | $29 |
| Developer | 5 | Yıllık | $79 |
| Agency | Sınırsız | Yıllık | $149 |
| Starter Lifetime | 1 | Ömür Boyu | $79 |
| Developer Lifetime | 5 | Ömür Boyu | $199 |
| Agency Lifetime | Sınırsız | Ömür Boyu | $399 |

## 🔒 Güvenlik

- Tüm API istekleri HMAC-SHA256 ile imzalanır
- Rate limiting: 100 istek/saat
- Admin paneli HTTP Basic Auth ile korunur
- SQL injection koruması (prepared statements)

## 📡 API Kullanımı

### Lisans Doğrulama
```bash
POST /api/v1/verify
Content-Type: application/json

{
    "license_key": "SWR-XXXX-XXXX-XXXX-XXXX",
    "domain": "example.com",
    "product_id": "smart-word-replacer"
}
```

### Aktivasyon
```bash
POST /api/v1/activate
Content-Type: application/json

{
    "license_key": "SWR-XXXX-XXXX-XXXX-XXXX",
    "domain": "example.com",
    "product_id": "smart-word-replacer",
    "site_name": "My Site"
}
```

## 🎛️ Admin Panel

Admin paneline şu adresten erişin:
```
https://license.zefre.net/admin/
```

Varsayılan giriş:
- Kullanıcı: `admin`
- Şifre: `zefre2024!` (DEĞİŞTİRİN!)

## 📧 Destek

Sorularınız için: admin@zefre.net

---
© 2024 Zefre. Tüm hakları saklıdır.
