<?php
/**
 * Admin Panel AJAX Handler
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/class-database.php';
require_once __DIR__ . '/../includes/class-license.php';

// Basit auth kontrolü
$admin_user = 'admin';
$admin_pass = 'zefre2024!';

if (!isset($_SERVER['PHP_AUTH_USER']) || 
    $_SERVER['PHP_AUTH_USER'] !== $admin_user || 
    $_SERVER['PHP_AUTH_PW'] !== $admin_pass) {
    header('HTTP/1.0 401 Unauthorized');
    exit('Unauthorized');
}

$db = Database::getInstance();
$license = new License();

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'get_activations':
        $license_id = intval($_GET['license_id'] ?? 0);
        
        if (!$license_id) {
            echo '<p>Geçersiz lisans ID</p>';
            break;
        }
        
        $lic = $license->getById($license_id);
        $activations = $db->select(
            "SELECT * FROM activations WHERE license_id = :id ORDER BY created_at DESC",
            ['id' => $license_id]
        );
        
        if (empty($activations)) {
            echo '<p>Henüz aktivasyon yok.</p>';
            break;
        }
        
        echo '<table style="width:100%; border-collapse:collapse;">';
        echo '<thead><tr><th style="padding:8px; border-bottom:1px solid #ddd;">Domain</th><th style="padding:8px; border-bottom:1px solid #ddd;">Durum</th><th style="padding:8px; border-bottom:1px solid #ddd;">Tarih</th></tr></thead>';
        echo '<tbody>';
        
        foreach ($activations as $act) {
            $status_class = $act['status'] === 'active' ? 'color:green;' : 'color:gray;';
            echo '<tr>';
            echo '<td style="padding:8px; border-bottom:1px solid #eee;"><strong>' . htmlspecialchars($act['domain']) . '</strong><br><small>' . htmlspecialchars($act['site_name'] ?? '') . '</small></td>';
            echo '<td style="padding:8px; border-bottom:1px solid #eee;' . $status_class . '">' . ucfirst($act['status']) . '</td>';
            echo '<td style="padding:8px; border-bottom:1px solid #eee;">' . date('d.m.Y H:i', strtotime($act['created_at'])) . '</td>';
            echo '</tr>';
        }
        
        echo '</tbody></table>';
        break;
        
    case 'get_stats':
        $data = [
            'licenses' => [
                'total' => $db->count('licenses'),
                'active' => $db->count('licenses', "status = 'active'"),
                'expired' => $db->count('licenses', "status = 'expired'"),
                'suspended' => $db->count('licenses', "status = 'suspended'")
            ],
            'activations' => [
                'total' => $db->count('activations'),
                'active' => $db->count('activations', "status = 'active'")
            ],
            'revenue' => [
                'total' => $db->selectOne("SELECT SUM(amount) as total FROM licenses WHERE status != 'revoked'")['total'] ?? 0,
                'this_month' => $db->selectOne("SELECT SUM(amount) as total FROM licenses WHERE status != 'revoked' AND MONTH(created_at) = MONTH(CURRENT_DATE())")['total'] ?? 0
            ]
        ];
        
        header('Content-Type: application/json');
        echo json_encode($data);
        break;
        
    case 'search_licenses':
        $query = $_GET['q'] ?? '';
        
        if (strlen($query) < 2) {
            echo json_encode([]);
            break;
        }
        
        $results = $db->select(
            "SELECT id, license_key, customer_name, customer_email, status, license_type 
             FROM licenses 
             WHERE license_key LIKE :q OR customer_email LIKE :q OR customer_name LIKE :q
             LIMIT 10",
            ['q' => '%' . $query . '%']
        );
        
        header('Content-Type: application/json');
        echo json_encode($results);
        break;
        
    default:
        echo 'Invalid action';
}
