<?php
/**
 * License Server Admin Panel
 * Minimal ama gerekli tüm işlevler
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/class-database.php';
require_once __DIR__ . '/../includes/class-license.php';

// Basit auth kontrolü
$admin_user = 'admin';
$admin_pass = 'zefre2024!'; // Production'da değiştirin!

if (!isset($_SERVER['PHP_AUTH_USER']) || 
    $_SERVER['PHP_AUTH_USER'] !== $admin_user || 
    $_SERVER['PHP_AUTH_PW'] !== $admin_pass) {
    header('WWW-Authenticate: Basic realm="License Admin"');
    header('HTTP/1.0 401 Unauthorized');
    echo 'Yetkisiz erişim';
    exit;
}

$db = Database::getInstance();
$license = new License();
$message = '';
$messageType = '';

// İşlemler
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Yeni lisans oluştur
    if (isset($_POST['action']) && $_POST['action'] === 'create') {
        $result = $license->create([
            'license_type' => $_POST['license_type'],
            'customer_name' => $_POST['customer_name'],
            'customer_email' => $_POST['customer_email'],
            'customer_phone' => $_POST['customer_phone'] ?? '',
            'notes' => $_POST['notes'] ?? ''
        ]);
        
        $message = "Lisans oluşturuldu: <strong>{$result['license_key']}</strong>";
        $messageType = 'success';
    }
    
    // Lisans durumu güncelle
    if (isset($_POST['action']) && $_POST['action'] === 'update_status') {
        $db->update(
            'licenses',
            ['status' => $_POST['status']],
            'id = :id',
            ['id' => $_POST['license_id']]
        );
        $message = 'Lisans durumu güncellendi';
        $messageType = 'success';
    }
    
    // Aktivasyon sil
    if (isset($_POST['action']) && $_POST['action'] === 'delete_activation') {
        $db->execute(
            "UPDATE activations SET status = 'removed' WHERE id = :id",
            ['id' => $_POST['activation_id']]
        );
        $message = 'Aktivasyon kaldırıldı';
        $messageType = 'success';
    }
}

// GET işlemleri
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $db->execute("DELETE FROM licenses WHERE id = :id", ['id' => $_GET['delete']]);
    $message = 'Lisans silindi';
    $messageType = 'warning';
}

// Sayfa
$page = isset($_GET['p']) ? max(1, intval($_GET['p'])) : 1;
$tab = $_GET['tab'] ?? 'licenses';

// Filtreler
$filters = [];
if (!empty($_GET['status'])) $filters['status'] = $_GET['status'];
if (!empty($_GET['search'])) $filters['search'] = $_GET['search'];

// İstatistikler
$stats = [
    'total' => $db->count('licenses'),
    'active' => $db->count('licenses', "status = 'active'"),
    'expired' => $db->count('licenses', "status = 'expired'"),
    'activations' => $db->count('activations', "status = 'active'"),
    'revenue' => $db->selectOne("SELECT SUM(amount) as total FROM licenses WHERE status != 'revoked'")['total'] ?? 0
];

// Lisansları getir
$licenses = $license->getAll($page, 20, $filters);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SWR License Admin</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background: #f0f2f5; color: #1d2327; line-height: 1.5; }
        .container { max-width: 1400px; margin: 0 auto; padding: 20px; }
        
        /* Header */
        .header { background: linear-gradient(135deg, #1d2327 0%, #2c3338 100%); color: white; padding: 20px 0; margin-bottom: 20px; }
        .header .container { display: flex; justify-content: space-between; align-items: center; }
        .header h1 { font-size: 24px; }
        .header .user-info { font-size: 14px; opacity: 0.8; }
        
        /* Stats Grid */
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px; }
        .stat-card { background: white; border-radius: 8px; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .stat-card h3 { font-size: 14px; color: #646970; margin-bottom: 5px; }
        .stat-card .number { font-size: 32px; font-weight: 700; color: #1d2327; }
        .stat-card.green .number { color: #00a32a; }
        .stat-card.blue .number { color: #2271b1; }
        .stat-card.orange .number { color: #dba617; }
        
        /* Tabs */
        .tabs { display: flex; gap: 5px; margin-bottom: 20px; }
        .tab { padding: 10px 20px; background: white; border: none; border-radius: 5px 5px 0 0; cursor: pointer; font-size: 14px; }
        .tab.active { background: #2271b1; color: white; }
        .tab:hover:not(.active) { background: #e5e5e5; }
        
        /* Card */
        .card { background: white; border-radius: 8px; padding: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .card h2 { margin-bottom: 15px; font-size: 18px; }
        
        /* Table */
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f9f9f9; font-weight: 600; font-size: 13px; color: #646970; }
        tr:hover { background: #f9f9f9; }
        
        /* Badges */
        .badge { display: inline-block; padding: 3px 8px; border-radius: 12px; font-size: 11px; font-weight: 600; }
        .badge.active { background: #d4edda; color: #155724; }
        .badge.expired { background: #f8d7da; color: #721c24; }
        .badge.suspended { background: #fff3cd; color: #856404; }
        .badge.revoked { background: #e2e3e5; color: #383d41; }
        .badge.starter { background: #e7f3ff; color: #2271b1; }
        .badge.developer { background: #e8f5e9; color: #00a32a; }
        .badge.agency { background: #fff3e0; color: #ef6c00; }
        .badge.lifetime { background: #f3e5f5; color: #7b1fa2; }
        
        /* Forms */
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 500; font-size: 14px; }
        .form-group input, .form-group select, .form-group textarea { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 14px; }
        .form-group input:focus, .form-group select:focus { outline: none; border-color: #2271b1; }
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        
        /* Buttons */
        .btn { display: inline-block; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; font-size: 14px; font-weight: 500; text-decoration: none; }
        .btn-primary { background: #2271b1; color: white; }
        .btn-primary:hover { background: #135e96; }
        .btn-danger { background: #d63638; color: white; }
        .btn-danger:hover { background: #b32d2e; }
        .btn-sm { padding: 5px 10px; font-size: 12px; }
        
        /* Message */
        .message { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .message.success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .message.warning { background: #fff3cd; color: #856404; border: 1px solid #ffeeba; }
        .message.error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        
        /* Filters */
        .filters { display: flex; gap: 10px; margin-bottom: 20px; align-items: center; flex-wrap: wrap; }
        .filters input, .filters select { padding: 8px 12px; border: 1px solid #ddd; border-radius: 5px; }
        
        /* License Key */
        .license-key { font-family: monospace; background: #f5f5f5; padding: 2px 6px; border-radius: 3px; font-size: 12px; }
        
        /* Pagination */
        .pagination { display: flex; gap: 5px; justify-content: center; margin-top: 20px; }
        .pagination a { padding: 8px 12px; border: 1px solid #ddd; border-radius: 5px; text-decoration: none; color: #1d2327; }
        .pagination a.active { background: #2271b1; color: white; border-color: #2271b1; }
        .pagination a:hover:not(.active) { background: #f5f5f5; }
        
        /* Modal */
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center; }
        .modal.show { display: flex; }
        .modal-content { background: white; border-radius: 8px; padding: 30px; max-width: 500px; width: 90%; max-height: 90vh; overflow-y: auto; }
        .modal-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .modal-close { background: none; border: none; font-size: 24px; cursor: pointer; color: #646970; }
        
        /* Actions */
        .actions { display: flex; gap: 5px; }
        
        /* Responsive */
        @media (max-width: 768px) {
            .form-row { grid-template-columns: 1fr; }
            .stats-grid { grid-template-columns: 1fr 1fr; }
            table { font-size: 12px; }
            th, td { padding: 8px; }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="container">
            <h1><i class="fas fa-key"></i> SWR License Admin</h1>
            <div class="user-info">
                <i class="fas fa-user"></i> admin
            </div>
        </div>
    </div>
    
    <div class="container">
        <?php if ($message): ?>
        <div class="message <?php echo $messageType; ?>">
            <?php echo $message; ?>
        </div>
        <?php endif; ?>
        
        <!-- Stats -->
        <div class="stats-grid">
            <div class="stat-card">
                <h3>Toplam Lisans</h3>
                <div class="number"><?php echo number_format($stats['total']); ?></div>
            </div>
            <div class="stat-card green">
                <h3>Aktif Lisans</h3>
                <div class="number"><?php echo number_format($stats['active']); ?></div>
            </div>
            <div class="stat-card orange">
                <h3>Aktif Site</h3>
                <div class="number"><?php echo number_format($stats['activations']); ?></div>
            </div>
            <div class="stat-card blue">
                <h3>Toplam Gelir</h3>
                <div class="number">$<?php echo number_format($stats['revenue']); ?></div>
            </div>
        </div>
        
        <!-- Tabs -->
        <div class="tabs">
            <a href="?tab=licenses" class="tab <?php echo $tab === 'licenses' ? 'active' : ''; ?>">
                <i class="fas fa-list"></i> Lisanslar
            </a>
            <a href="?tab=create" class="tab <?php echo $tab === 'create' ? 'active' : ''; ?>">
                <i class="fas fa-plus"></i> Yeni Lisans
            </a>
            <a href="?tab=activations" class="tab <?php echo $tab === 'activations' ? 'active' : ''; ?>">
                <i class="fas fa-desktop"></i> Aktivasyonlar
            </a>
        </div>
        
        <?php if ($tab === 'licenses'): ?>
        <!-- Lisanslar -->
        <div class="card">
            <form class="filters" method="get">
                <input type="hidden" name="tab" value="licenses">
                <input type="text" name="search" placeholder="Ara..." value="<?php echo htmlspecialchars($_GET['search'] ?? ''); ?>">
                <select name="status">
                    <option value="">Tüm Durumlar</option>
                    <option value="active" <?php echo ($_GET['status'] ?? '') === 'active' ? 'selected' : ''; ?>>Aktif</option>
                    <option value="expired" <?php echo ($_GET['status'] ?? '') === 'expired' ? 'selected' : ''; ?>>Süresi Dolmuş</option>
                    <option value="suspended" <?php echo ($_GET['status'] ?? '') === 'suspended' ? 'selected' : ''; ?>>Askıda</option>
                </select>
                <button type="submit" class="btn btn-primary btn-sm">Filtrele</button>
                <a href="?tab=licenses" class="btn btn-sm">Temizle</a>
            </form>
            
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Lisans Anahtarı</th>
                        <th>Tip</th>
                        <th>Müşteri</th>
                        <th>Durum</th>
                        <th>Site</th>
                        <th>Bitiş</th>
                        <th>İşlem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($licenses['data'] as $lic): ?>
                    <?php 
                    $activations = $license->getActivations($lic['id']);
                    $sites_used = count($activations);
                    ?>
                    <tr>
                        <td><?php echo $lic['id']; ?></td>
                        <td><span class="license-key"><?php echo htmlspecialchars($lic['license_key']); ?></span></td>
                        <td>
                            <?php 
                            $type = $lic['license_type'];
                            $badge_class = strpos($type, 'lifetime') !== false ? 'lifetime' : (strpos($type, 'agency') !== false ? 'agency' : (strpos($type, 'developer') !== false ? 'developer' : 'starter'));
                            ?>
                            <span class="badge <?php echo $badge_class; ?>"><?php echo ucfirst(str_replace('_', ' ', $type)); ?></span>
                        </td>
                        <td>
                            <strong><?php echo htmlspecialchars($lic['customer_name'] ?? '-'); ?></strong><br>
                            <small><?php echo htmlspecialchars($lic['customer_email']); ?></small>
                        </td>
                        <td><span class="badge <?php echo $lic['status']; ?>"><?php echo ucfirst($lic['status']); ?></span></td>
                        <td><?php echo $sites_used; ?>/<?php echo $lic['max_sites'] >= 999 ? '∞' : $lic['max_sites']; ?></td>
                        <td><?php echo $lic['expires_at'] ? date('d.m.Y', strtotime($lic['expires_at'])) : '♾️'; ?></td>
                        <td class="actions">
                            <button class="btn btn-sm btn-primary" onclick="showActivations(<?php echo $lic['id']; ?>)">
                                <i class="fas fa-eye"></i>
                            </button>
                            <a href="?delete=<?php echo $lic['id']; ?>&tab=licenses" class="btn btn-sm btn-danger" onclick="return confirm('Silmek istediğinize emin misiniz?')">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <?php if ($licenses['pages'] > 1): ?>
            <div class="pagination">
                <?php for ($i = 1; $i <= $licenses['pages']; $i++): ?>
                <a href="?tab=licenses&p=<?php echo $i; ?>&<?php echo http_build_query($filters); ?>" class="<?php echo $i == $page ? 'active' : ''; ?>">
                    <?php echo $i; ?>
                </a>
                <?php endfor; ?>
            </div>
            <?php endif; ?>
        </div>
        
        <?php elseif ($tab === 'create'): ?>
        <!-- Yeni Lisans -->
        <div class="card">
            <h2><i class="fas fa-plus-circle"></i> Yeni Lisans Oluştur</h2>
            
            <form method="post">
                <input type="hidden" name="action" value="create">
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Lisans Tipi</label>
                        <select name="license_type" required>
                            <?php foreach (LICENSE_TYPES as $key => $type): ?>
                            <option value="<?php echo $key; ?>">
                                <?php echo $type['name']; ?> - $<?php echo $type['price']; ?> 
                                (<?php echo $type['sites'] >= 999 ? 'Sınırsız' : $type['sites']; ?> site)
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Müşteri E-posta</label>
                        <input type="email" name="customer_email" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Müşteri Adı</label>
                        <input type="text" name="customer_name">
                    </div>
                    <div class="form-group">
                        <label>Telefon</label>
                        <input type="text" name="customer_phone">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Notlar</label>
                    <textarea name="notes" rows="3" placeholder="Opsiyonel notlar..."></textarea>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-key"></i> Lisans Oluştur
                </button>
            </form>
        </div>
        
        <?php elseif ($tab === 'activations'): ?>
        <!-- Aktivasyonlar -->
        <div class="card">
            <h2><i class="fas fa-desktop"></i> Son Aktivasyonlar</h2>
            
            <?php
            $recent_activations = $db->select(
                "SELECT a.*, l.license_key, l.license_type 
                 FROM activations a 
                 JOIN licenses l ON a.license_id = l.id 
                 WHERE a.status = 'active'
                 ORDER BY a.created_at DESC 
                 LIMIT 50"
            );
            ?>
            
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Lisans</th>
                        <th>Domain</th>
                        <th>Site Adı</th>
                        <th>IP</th>
                        <th>Tarih</th>
                        <th>İşlem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recent_activations as $act): ?>
                    <tr>
                        <td><?php echo $act['id']; ?></td>
                        <td><span class="license-key"><?php echo htmlspecialchars($act['license_key']); ?></span></td>
                        <td><strong><?php echo htmlspecialchars($act['domain']); ?></strong></td>
                        <td><?php echo htmlspecialchars($act['site_name'] ?? '-'); ?></td>
                        <td><small><?php echo htmlspecialchars($act['ip_address'] ?? '-'); ?></small></td>
                        <td><?php echo date('d.m.Y H:i', strtotime($act['created_at'])); ?></td>
                        <td>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="action" value="delete_activation">
                                <input type="hidden" name="activation_id" value="<?php echo $act['id']; ?>">
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Aktivasyonu kaldırmak istediğinize emin misiniz?')">
                                    <i class="fas fa-times"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Aktivasyon Modal -->
    <div class="modal" id="activationsModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Site Aktivasyonları</h3>
                <button class="modal-close" onclick="closeModal()">&times;</button>
            </div>
            <div id="activationsContent">
                Yükleniyor...
            </div>
        </div>
    </div>
    
    <script>
    function showActivations(licenseId) {
        document.getElementById('activationsModal').classList.add('show');
        
        // AJAX ile aktivasyonları getir
        fetch('ajax.php?action=get_activations&license_id=' + licenseId)
            .then(r => r.text())
            .then(html => {
                document.getElementById('activationsContent').innerHTML = html;
            });
    }
    
    function closeModal() {
        document.getElementById('activationsModal').classList.remove('show');
    }
    
    // Modal dışına tıklayınca kapat
    document.getElementById('activationsModal').addEventListener('click', function(e) {
        if (e.target === this) closeModal();
    });
    </script>
</body>
</html>
