<?php
/**
 * License Activate API Endpoint
 * POST /api/v1/activate
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/class-database.php';
require_once __DIR__ . '/../../includes/class-license.php';
require_once __DIR__ . '/../../includes/class-api-handler.php';

$api = new APIHandler();
$data = $api->handleRequest();

// Gerekli alanlar
$required = ['license_key', 'domain', 'product_id'];
foreach ($required as $field) {
    if (empty($data[$field])) {
        $api->sendError('missing_field', "Eksik alan: {$field}", 400);
    }
}

// Product ID kontrolü
if ($data['product_id'] !== PRODUCT_ID) {
    $api->sendError('invalid_product', 'Geçersiz ürün', 400);
}

// İmza doğrulama
if (isset($data['signature']) && !$api->verifySignature($data)) {
    $api->sendError('invalid_signature', 'Geçersiz imza', 401);
}

// Lisans aktive et
$license = new License();
$result = $license->activate($data['license_key'], $data['domain'], [
    'domain_hash' => $data['domain_hash'] ?? null,
    'site_name' => $data['site_name'] ?? null,
    'version' => $data['version'] ?? null,
    'wp_version' => $data['wp_version'] ?? null,
    'php_version' => $data['php_version'] ?? null
]);

// Log kaydet
$license_data = $license->getByKey($data['license_key']);
$api->logRequest(
    'activate',
    $license_data['id'] ?? null,
    $data['domain'],
    $result['success'] ? 'success' : 'failed',
    $result['message'] ?? ''
);

if ($result['success']) {
    $api->sendSuccess([
        'message' => $result['message'],
        'license_type' => $result['license_type'],
        'expires_at' => $result['expires_at'],
        'sites_used' => $result['sites_used'],
        'sites_allowed' => $result['sites_allowed'],
        'features' => $result['features']
    ]);
} else {
    $response = [
        'error' => $result['error'],
        'message' => $result['message']
    ];
    
    // Site limiti aşıldıysa detay ekle
    if (isset($result['sites_used'])) {
        $response['sites_used'] = $result['sites_used'];
        $response['sites_allowed'] = $result['sites_allowed'];
    }
    
    $api->sendError($result['error'], $result['message']);
}
