<?php
/**
 * License Deactivate API Endpoint
 * POST /api/v1/deactivate
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/class-database.php';
require_once __DIR__ . '/../../includes/class-license.php';
require_once __DIR__ . '/../../includes/class-api-handler.php';

$api = new APIHandler();
$data = $api->handleRequest();

// Gerekli alanlar
$required = ['license_key', 'domain', 'product_id'];
foreach ($required as $field) {
    if (empty($data[$field])) {
        $api->sendError('missing_field', "Eksik alan: {$field}", 400);
    }
}

// Product ID kontrolü
if ($data['product_id'] !== PRODUCT_ID) {
    $api->sendError('invalid_product', 'Geçersiz ürün', 400);
}

// İmza doğrulama
if (isset($data['signature']) && !$api->verifySignature($data)) {
    $api->sendError('invalid_signature', 'Geçersiz imza', 401);
}

// Lisans deaktive et
$license = new License();
$result = $license->deactivate($data['license_key'], $data['domain']);

// Log kaydet
$license_data = $license->getByKey($data['license_key']);
$api->logRequest(
    'deactivate',
    $license_data['id'] ?? null,
    $data['domain'],
    $result['success'] ? 'success' : 'failed',
    $result['message'] ?? ''
);

if ($result['success']) {
    $api->sendSuccess(['message' => $result['message']]);
} else {
    $api->sendError($result['error'], $result['message']);
}
