<?php
/**
 * License Verify API Endpoint
 * POST /api/v1/verify
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/class-database.php';
require_once __DIR__ . '/../../includes/class-license.php';
require_once __DIR__ . '/../../includes/class-api-handler.php';

$api = new APIHandler();
$data = $api->handleRequest();

// Gerekli alanlar
$required = ['license_key', 'domain', 'product_id'];
foreach ($required as $field) {
    if (empty($data[$field])) {
        $api->sendError('missing_field', "Eksik alan: {$field}", 400);
    }
}

// Product ID kontrolü
if ($data['product_id'] !== PRODUCT_ID) {
    $api->sendError('invalid_product', 'Geçersiz ürün', 400);
}

// İmza doğrulama (opsiyonel ama önerilen)
if (isset($data['signature']) && !$api->verifySignature($data)) {
    $api->sendError('invalid_signature', 'Geçersiz imza', 401);
}

// Lisans doğrula
$license = new License();
$result = $license->verify($data['license_key'], $data['domain']);

// Log kaydet
$license_data = $license->getByKey($data['license_key']);
$api->logRequest(
    'verify',
    $license_data['id'] ?? null,
    $data['domain'],
    $result['valid'] ? 'success' : 'failed',
    $result['message'] ?? ''
);

if ($result['valid']) {
    $api->sendSuccess([
        'license_type' => $result['license_type'],
        'expires_at' => $result['expires_at'],
        'sites_used' => $result['sites_used'],
        'sites_allowed' => $result['sites_allowed'],
        'domain_active' => $result['domain_active'],
        'features' => $result['features']
    ]);
} else {
    $api->sendError($result['error'], $result['message']);
}
