<?php
/**
 * Payment Callback Page
 * Paynet ödeme sonrası callback
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/class-database.php';
require_once __DIR__ . '/includes/class-license.php';
require_once __DIR__ . '/includes/class-paynet.php';

$db = Database::getInstance();

// Order ID kontrol
$order_id = $_GET['order'] ?? '';
if (empty($order_id)) {
    header('Location: checkout.php?error=invalid_order');
    exit;
}

// Ödeme kaydını bul
$payment = $db->selectOne(
    "SELECT * FROM payments WHERE transaction_id = :tid",
    ['tid' => $order_id]
);

if (!$payment) {
    header('Location: checkout.php?error=payment_not_found');
    exit;
}

// Zaten işlendi mi?
if ($payment['status'] === 'completed' && $payment['license_id']) {
    $license = $db->selectOne(
        "SELECT license_key FROM licenses WHERE id = :id",
        ['id' => $payment['license_id']]
    );
    
    header('Location: success.php?key=' . urlencode($license['license_key']));
    exit;
}

$error = '';
$license_key = '';

try {
    // Paynet'ten ödeme durumunu doğrula
    $paynet = new Paynet();
    
    // Gerçek senaryoda Paynet callback parametrelerini kontrol et
    // Şimdilik simüle ediyoruz
    $transaction_id = $_GET['transaction_id'] ?? $order_id;
    $hash = $_GET['hash'] ?? '';
    
    // Test modunda otomatik başarılı kabul et
    if (PAYNET_TEST_MODE || !empty($_GET['success'])) {
        $payment_verified = true;
    } else {
        $result = $paynet->verifyPayment($transaction_id, $hash);
        $payment_verified = $result['success'] ?? false;
    }
    
    if ($payment_verified) {
        // Lisans oluştur
        $license = new License();
        $license_data = $license->create([
            'license_type' => $payment['product_type'],
            'customer_email' => $payment['customer_email'],
            'customer_name' => $payment['customer_name'],
            'payment_id' => $order_id,
            'payment_method' => 'paynet'
        ]);
        
        $license_key = $license_data['license_key'];
        
        // Ödeme kaydını güncelle
        $db->update(
            'payments',
            [
                'status' => 'completed',
                'license_id' => $license_data['id'],
                'completed_at' => date('Y-m-d H:i:s')
            ],
            'id = :id',
            ['id' => $payment['id']]
        );
        
        // E-posta gönder (basit)
        $to = $payment['customer_email'];
        $subject = 'Smart Word Replacer - Lisans Anahtarınız';
        $message = "Merhaba " . ($payment['customer_name'] ?: 'Değerli Müşterimiz') . ",\n\n";
        $message .= "Smart Word Replacer Pro satın aldığınız için teşekkür ederiz!\n\n";
        $message .= "Lisans Anahtarınız: " . $license_key . "\n\n";
        $message .= "Bu anahtarı WordPress admin panelinizde Kelime Değiştirici > Lisans menüsünden aktive edebilirsiniz.\n\n";
        $message .= "Sorularınız için: " . ADMIN_EMAIL . "\n\n";
        $message .= "İyi çalışmalar,\nSmart Word Replacer Ekibi";
        
        $headers = "From: Smart Word Replacer <" . ADMIN_EMAIL . ">\r\n";
        $headers .= "Reply-To: " . ADMIN_EMAIL . "\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
        
        @mail($to, $subject, $message, $headers);
        
        // Başarı sayfasına yönlendir
        header('Location: success.php?key=' . urlencode($license_key));
        exit;
        
    } else {
        $error = 'Ödeme doğrulanamadı. Lütfen destek ile iletişime geçin.';
        
        // Ödeme kaydını güncelle
        $db->update(
            'payments',
            ['status' => 'failed'],
            'id = :id',
            ['id' => $payment['id']]
        );
    }
    
} catch (Exception $e) {
    $error = 'Bir hata oluştu: ' . $e->getMessage();
}

// Hata varsa göster
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ödeme İşleniyor - Smart Word Replacer</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .card {
            background: #fff;
            border-radius: 16px;
            padding: 40px;
            max-width: 500px;
            text-align: center;
        }
        
        .error-icon {
            font-size: 60px;
            margin-bottom: 20px;
        }
        
        h2 {
            color: #333;
            margin-bottom: 15px;
        }
        
        p {
            color: #666;
            line-height: 1.6;
        }
        
        .btn {
            display: inline-block;
            margin-top: 20px;
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #fff;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="error-icon">⚠️</div>
        <h2>Ödeme Sorunu</h2>
        <p><?php echo htmlspecialchars($error ?: 'Ödeme işlemi tamamlanamadı.'); ?></p>
        <p>Sipariş No: <strong><?php echo htmlspecialchars($order_id); ?></strong></p>
        <p>
            Sorun devam ederse lütfen bu sipariş numarası ile 
            <a href="mailto:<?php echo ADMIN_EMAIL; ?>">destek ekibimize</a> ulaşın.
        </p>
        <a href="checkout.php" class="btn">Tekrar Dene</a>
    </div>
</body>
</html>
