<?php
/**
 * Checkout Page
 * Lisans satın alma sayfası
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/class-database.php';
require_once __DIR__ . '/includes/class-license.php';
require_once __DIR__ . '/includes/class-paynet.php';

// Lisans tipi al
$type = isset($_GET['type']) ? $_GET['type'] : null;

if (!$type || !isset(LICENSE_TYPES[$type])) {
    $type = null;
}

$selected_plan = $type ? LICENSE_TYPES[$type] : null;

// Form gönderildi mi?
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['checkout'])) {
    $plan_type = $_POST['plan_type'] ?? '';
    $email = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
    $name = htmlspecialchars($_POST['name'] ?? '', ENT_QUOTES, 'UTF-8');
    
    if (!$plan_type || !isset(LICENSE_TYPES[$plan_type])) {
        $error = 'Geçersiz plan seçimi';
    } elseif (!$email) {
        $error = 'Geçerli bir e-posta adresi girin';
    } else {
        $plan = LICENSE_TYPES[$plan_type];
        
        try {
            $paynet = new Paynet();
            $order_id = $paynet->generateOrderId();
            
            // Ödeme başlat
            $payment = $paynet->createPayment([
                'amount' => $plan['price'],
                'order_id' => $order_id,
                'description' => 'Smart Word Replacer - ' . $plan['name'],
                'email' => $email,
                'name' => $name,
                'return_url' => SITE_URL . '/callback.php?order=' . $order_id,
                'cancel_url' => SITE_URL . '/checkout.php?type=' . $plan_type . '&cancelled=1'
            ]);
            
            if (isset($payment['payment_url'])) {
                // Ödeme bilgilerini kaydet
                $db = Database::getInstance();
                $db->insert('payments', [
                    'transaction_id' => $order_id,
                    'payment_method' => 'paynet',
                    'amount' => $plan['price'],
                    'currency' => 'USD',
                    'status' => 'pending',
                    'customer_email' => $email,
                    'customer_name' => $name,
                    'product_type' => $plan_type,
                    'raw_response' => json_encode($payment)
                ]);
                
                // Paynet ödeme sayfasına yönlendir
                header('Location: ' . $payment['payment_url']);
                exit;
            } else {
                $error = 'Ödeme başlatılamadı: ' . ($payment['error'] ?? 'Bilinmeyen hata');
            }
        } catch (Exception $e) {
            $error = 'Bir hata oluştu: ' . $e->getMessage();
        }
    }
}

// İptal edildi mi?
if (isset($_GET['cancelled'])) {
    $error = 'Ödeme iptal edildi';
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Satın Al - Smart Word Replacer</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .header {
            text-align: center;
            margin-bottom: 40px;
            color: #fff;
        }
        
        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 1.1rem;
        }
        
        .pricing-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }
        
        .plan-card {
            background: #fff;
            border-radius: 16px;
            padding: 30px;
            text-align: center;
            transition: transform 0.3s, box-shadow 0.3s;
            position: relative;
            cursor: pointer;
        }
        
        .plan-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
        }
        
        .plan-card.popular {
            border: 3px solid #667eea;
        }
        
        .plan-card.selected {
            border: 3px solid #00c853;
            background: #f0fff4;
        }
        
        .popular-badge {
            position: absolute;
            top: -12px;
            left: 50%;
            transform: translateX(-50%);
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #fff;
            padding: 5px 20px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .plan-card h3 {
            font-size: 1.5rem;
            margin-bottom: 10px;
            color: #333;
        }
        
        .plan-card .price {
            font-size: 3rem;
            font-weight: 700;
            color: #667eea;
            margin: 20px 0;
        }
        
        .plan-card .price span {
            font-size: 1rem;
            font-weight: 400;
            color: #666;
        }
        
        .plan-card .sites {
            background: #f5f5f5;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 500;
        }
        
        .plan-card .features {
            list-style: none;
            text-align: left;
            margin-bottom: 20px;
        }
        
        .plan-card .features li {
            padding: 8px 0;
            border-bottom: 1px solid #eee;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .plan-card .features li:last-child {
            border-bottom: none;
        }
        
        .plan-card .features li::before {
            content: "✓";
            color: #00c853;
            font-weight: bold;
        }
        
        .lifetime-link {
            color: #666;
            font-size: 14px;
            margin-top: 15px;
        }
        
        .lifetime-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
        }
        
        .checkout-form {
            max-width: 500px;
            margin: 0 auto;
            background: #fff;
            border-radius: 16px;
            padding: 40px;
        }
        
        .checkout-form h2 {
            margin-bottom: 30px;
            text-align: center;
            color: #333;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #333;
        }
        
        .form-group input {
            width: 100%;
            padding: 14px;
            border: 2px solid #eee;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus {
            border-color: #667eea;
            outline: none;
        }
        
        .selected-plan {
            background: #f8f9ff;
            border: 2px solid #667eea;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .selected-plan h4 {
            color: #667eea;
            margin-bottom: 5px;
        }
        
        .selected-plan .total {
            font-size: 2rem;
            font-weight: 700;
            color: #333;
        }
        
        .btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #fff;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.4);
        }
        
        .error {
            background: #ffebee;
            color: #c62828;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .guarantee {
            text-align: center;
            margin-top: 20px;
            color: #666;
            font-size: 14px;
        }
        
        .guarantee strong {
            color: #00c853;
        }
        
        @media (max-width: 768px) {
            .header h1 {
                font-size: 1.8rem;
            }
            
            .plan-card .price {
                font-size: 2.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🚀 Smart Word Replacer Pro</h1>
            <p>Tüm özelliklerin kilidini açın ve sitenizi daha iyi yönetin</p>
        </div>
        
        <?php if (!$selected_plan): ?>
        <!-- Plan Seçimi -->
        <div class="pricing-grid">
            <?php 
            $display_plans = ['starter', 'developer', 'agency'];
            foreach ($display_plans as $plan_key): 
                $plan = LICENSE_TYPES[$plan_key];
            ?>
            <div class="plan-card <?php echo $plan_key === 'developer' ? 'popular' : ''; ?>" 
                 onclick="window.location='?type=<?php echo $plan_key; ?>'">
                <?php if ($plan_key === 'developer'): ?>
                    <div class="popular-badge">En Popüler</div>
                <?php endif; ?>
                
                <h3><?php echo $plan['name']; ?></h3>
                <div class="price">
                    $<?php echo $plan['price']; ?>
                    <span>/yıl</span>
                </div>
                <div class="sites">
                    <?php echo $plan['sites'] >= 999 ? 'Sınırsız Site' : $plan['sites'] . ' Site'; ?>
                </div>
                
                <ul class="features">
                    <li>Metin Değişimi</li>
                    <li>URL Değişimi</li>
                    <li>301 Yönlendirmeler</li>
                    <li>Toplu İşlemler</li>
                    <li>İstatistikler</li>
                    <li>Öncelikli Destek</li>
                </ul>
                
                <p class="lifetime-link">
                    veya <a href="?type=<?php echo $plan_key; ?>_lifetime">
                        $<?php echo LICENSE_TYPES[$plan_key . '_lifetime']['price']; ?> Ömür Boyu
                    </a>
                </p>
            </div>
            <?php endforeach; ?>
        </div>
        
        <?php else: ?>
        <!-- Checkout Form -->
        <div class="checkout-form">
            <h2>Ödeme Bilgileri</h2>
            
            <?php if ($error): ?>
                <div class="error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <div class="selected-plan">
                <h4><?php echo $selected_plan['name']; ?></h4>
                <div class="total">$<?php echo $selected_plan['price']; ?></div>
                <small>
                    <?php echo $selected_plan['sites'] >= 999 ? 'Sınırsız Site' : $selected_plan['sites'] . ' Site'; ?>
                    - 
                    <?php echo $selected_plan['period'] === 'lifetime' ? 'Ömür Boyu' : 'Yıllık'; ?>
                </small>
            </div>
            
            <form method="post">
                <input type="hidden" name="plan_type" value="<?php echo htmlspecialchars($type); ?>">
                
                <div class="form-group">
                    <label for="name">Ad Soyad</label>
                    <input type="text" id="name" name="name" required 
                           value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>">
                </div>
                
                <div class="form-group">
                    <label for="email">E-posta Adresi</label>
                    <input type="email" id="email" name="email" required
                           value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">
                    <small style="color:#666;">Lisans anahtarınız bu adrese gönderilecektir.</small>
                </div>
                
                <button type="submit" name="checkout" class="btn">
                    💳 Güvenli Ödeme Yap
                </button>
            </form>
            
            <p class="guarantee">
                🛡️ <strong>30 Gün Para İade Garantisi</strong><br>
                Memnun kalmazsanız paranızı iade ediyoruz.
            </p>
            
            <p style="text-align:center; margin-top:20px;">
                <a href="checkout.php" style="color:#667eea;">← Planları Gör</a>
            </p>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
