<?php
/**
 * License Server Configuration
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

// Hata gösterimi (production'da kapatılmalı)
define('DEBUG_MODE', false);

if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Timezone
date_default_timezone_set('Europe/Istanbul');

// Veritabanı Ayarları
define('DB_HOST', 'localhost');
define('DB_NAME', 'license_db');
define('DB_USER', 'license_user');
define('DB_PASS', 'your_secure_password');
define('DB_CHARSET', 'utf8mb4');

// API Ayarları
define('API_SECRET_KEY', 'swr_2024_secure_key_x7k9m2');
define('API_VERSION', '1.0.0');
define('PRODUCT_ID', 'smart-word-replacer');

// Güvenlik Ayarları
define('RATE_LIMIT_REQUESTS', 100);
define('RATE_LIMIT_WINDOW', 3600); // 1 saat
define('GRACE_PERIOD_HOURS', 6);
define('CACHE_DURATION_HOURS', 24);

// Paynet Ayarları
define('PAYNET_TEST_MODE', true);
define('PAYNET_SECRET_KEY', 'your_paynet_secret_key');
define('PAYNET_PUBLIC_KEY', 'your_paynet_public_key');

// Lisans Tipleri ve Fiyatları
define('LICENSE_TYPES', [
    'starter' => [
        'name' => 'Starter',
        'sites' => 1,
        'price' => 29,
        'period' => 'yearly'
    ],
    'developer' => [
        'name' => 'Developer',
        'sites' => 5,
        'price' => 79,
        'period' => 'yearly'
    ],
    'agency' => [
        'name' => 'Agency',
        'sites' => 999,
        'price' => 149,
        'period' => 'yearly'
    ],
    'starter_lifetime' => [
        'name' => 'Starter Lifetime',
        'sites' => 1,
        'price' => 79,
        'period' => 'lifetime'
    ],
    'developer_lifetime' => [
        'name' => 'Developer Lifetime',
        'sites' => 5,
        'price' => 199,
        'period' => 'lifetime'
    ],
    'agency_lifetime' => [
        'name' => 'Agency Lifetime',
        'sites' => 999,
        'price' => 399,
        'period' => 'lifetime'
    ]
]);

// Pro Özellikler
define('PRO_FEATURES', [
    'text_replacement',
    'url_replacement',
    'redirects',
    'bulk_operations',
    'stats',
    'term_replacement',
    'meta_replacement'
]);

// Site URL'leri
define('SITE_URL', 'https://license.zefre.net');
define('ADMIN_EMAIL', 'admin@zefre.net');

// Session başlat (admin panel için)
if (session_status() === PHP_SESSION_NONE && php_sapi_name() !== 'cli') {
    session_start();
}
