<?php
/**
 * Success Page
 * Başarılı ödeme sonrası lisans anahtarı gösterimi
 * 
 * @package SWR_License_Server
 * @since 1.0.0
 */

require_once __DIR__ . '/includes/config.php';

$license_key = $_GET['key'] ?? '';

if (empty($license_key)) {
    header('Location: checkout.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Satın Alma Başarılı! - Smart Word Replacer</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #00c853 0%, #00a152 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .success-card {
            background: #fff;
            border-radius: 20px;
            padding: 50px;
            max-width: 600px;
            text-align: center;
            box-shadow: 0 20px 60px rgba(0,0,0,0.2);
        }
        
        .success-icon {
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, #00c853 0%, #00a152 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            font-size: 50px;
            color: #fff;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 2rem;
        }
        
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 1.1rem;
        }
        
        .license-box {
            background: #f8f9ff;
            border: 3px dashed #667eea;
            border-radius: 12px;
            padding: 25px;
            margin: 30px 0;
        }
        
        .license-box label {
            display: block;
            color: #666;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        .license-key {
            font-family: 'Courier New', monospace;
            font-size: 1.5rem;
            font-weight: 700;
            color: #333;
            letter-spacing: 2px;
            word-break: break-all;
            user-select: all;
        }
        
        .copy-btn {
            margin-top: 15px;
            padding: 10px 25px;
            background: #667eea;
            color: #fff;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .copy-btn:hover {
            background: #5a6fd6;
            transform: translateY(-2px);
        }
        
        .copy-btn.copied {
            background: #00c853;
        }
        
        .instructions {
            background: #fff8e1;
            border-radius: 12px;
            padding: 25px;
            margin: 30px 0;
            text-align: left;
        }
        
        .instructions h3 {
            color: #f57c00;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .instructions ol {
            margin-left: 20px;
            color: #666;
        }
        
        .instructions li {
            margin-bottom: 10px;
            line-height: 1.6;
        }
        
        .instructions code {
            background: #fff;
            padding: 2px 8px;
            border-radius: 4px;
            font-family: monospace;
        }
        
        .email-note {
            color: #666;
            font-size: 14px;
            margin-top: 30px;
            padding: 15px;
            background: #f5f5f5;
            border-radius: 8px;
        }
        
        .support-link {
            margin-top: 20px;
            color: #666;
            font-size: 14px;
        }
        
        .support-link a {
            color: #667eea;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="success-card">
        <div class="success-icon">✓</div>
        
        <h1>Tebrikler! 🎉</h1>
        <p class="subtitle">Smart Word Replacer Pro satın aldığınız için teşekkür ederiz!</p>
        
        <div class="license-box">
            <label>Lisans Anahtarınız</label>
            <div class="license-key" id="license-key"><?php echo htmlspecialchars($license_key); ?></div>
            <button class="copy-btn" onclick="copyLicense()">📋 Kopyala</button>
        </div>
        
        <div class="instructions">
            <h3>📝 Aktivasyon Adımları</h3>
            <ol>
                <li>WordPress admin panelinize giriş yapın</li>
                <li><code>Kelime Değiştirici → Lisans</code> menüsüne gidin</li>
                <li>Yukarıdaki lisans anahtarını yapıştırın</li>
                <li><strong>Aktive Et</strong> butonuna tıklayın</li>
                <li>Tüm Pro özellikler aktif olacaktır! 🚀</li>
            </ol>
        </div>
        
        <div class="email-note">
            📧 Lisans anahtarınız ayrıca e-posta adresinize gönderilmiştir.<br>
            Lütfen spam klasörünüzü de kontrol edin.
        </div>
        
        <p class="support-link">
            Sorularınız mı var? <a href="mailto:<?php echo ADMIN_EMAIL; ?>">Destek Ekibimize Ulaşın</a>
        </p>
    </div>
    
    <script>
        function copyLicense() {
            var key = document.getElementById('license-key').textContent;
            navigator.clipboard.writeText(key).then(function() {
                var btn = document.querySelector('.copy-btn');
                btn.textContent = '✓ Kopyalandı!';
                btn.classList.add('copied');
                
                setTimeout(function() {
                    btn.textContent = '📋 Kopyala';
                    btn.classList.remove('copied');
                }, 2000);
            });
        }
    </script>
</body>
</html>
